<?xml version="1.0"?>
<queryset>

<fullquery name="get_users">      
<querytext>
      
select t.user_id,
       p1.first_names || ' ' || p1.last_name as full_name,
       p2.email,
       null as remove_link
  from ttl_v_users t, persons p1, parties p2
  where t.package_id = :package_id and 
        t.user_id = p1.person_id and 
        p1.person_id = p2.party_id
  order by lower(p1.first_names), lower(p1. last_name)

</querytext>
</fullquery>


 
<fullquery name="search_users">      
<querytext>
      
select u.user_id,
       p2.email,
       p1.first_names,
       p1.last_name,
       null as add_link
  from users u, persons p1, parties p2
  where u.user_id = p1.person_id and 
        p1.person_id = p2.party_id and 
        not exists (select 1 from ttl_v_users t
                      where t.package_id = :package_id and 
                            t.user_id = u.user_id) and 
        lower(last_name) like lower(:last_name_start) || '%'
  order by lower(last_name), lower(first_names)
    
</querytext>
</fullquery>

 
</queryset>
