set package_id [ad_conn package_id] 

set title "Ticket tracker administration"

set context {}

set master_template [ttl_master_template]

db_1row count_users {
    select count(*) as num_users from ttl_v_users where package_id = :package_id
}


if { $num_users > 0 } {

    # This query doesn't make any sense if there are no users,
    # so we use an alternative one in that case

    set query "
    select
        v.area_id,
        v.name,
        v.full_name,
        v.user_id,
        decode(a.user_id, null, 0, 1) as already_assigned_p
    from ttl_area_assignments a,
        (select 
            ta.area_id, 
            ta.name,
            p.first_names || ' ' || p.last_name as full_name,
            tu.user_id
         from ttl_va_areas ta, ttl_v_users tu, persons p
         where ta.context_id = :package_id 
         and tu.package_id = :package_id
         and tu.user_id = p.person_id) v
    where v.area_id = a.area_id(+)
    and v.user_id = a.user_id(+)
    order by v.name, v.full_name"

	db_foreach get_users $query {

		set name_of_area($area_id) $name

		if [info exists already_assigned_p] {
			if { $already_assigned_p } {
				append assigned_list($area_id) "<br>&nbsp;&nbsp;&nbsp; $full_name 
            <span class=tiny>(<a href=default-assignee-ae?user_id=$user_id&area_id=$area_id&action=remove>remove</a>)</span>"
			} else {
				append unassigned_optionlist($area_id) "<option value=$user_id>$full_name</option>"
			}
		}
	}
} else {

    set query "
    select
        ta.area_id,
        ta.name
    from ttl_va_areas ta
    where ta.context_id = :package_id 
    order by ta.name"

	db_foreach get_area $query {

		set name_of_area($area_id) $name

		if [info exists already_assigned_p] {
			if { $already_assigned_p } {
				append assigned_list($area_id) "<br>&nbsp;&nbsp;&nbsp; $full_name 
            <span class=tiny>(<a href=default-assignee-ae?user_id=$user_id&area_id=$area_id&action=remove>remove</a>)</span>"
			} else {
				append unassigned_optionlist($area_id) "<option value=$user_id>$full_name</option>"
			}
		}
	}
}

foreach area_id [array names name_of_area] {

    if ![info exists assigned_list($area_id)] {
        set assigned_list($area_id) "<em>none</em>"
    }

    if [info exists unassigned_optionlist($area_id)] {

        set unassigned_optionlist($area_id) "
        <select name=user_id>
        $unassigned_optionlist($area_id)
        </select>
        <input type=submit value=Add>"
    } else {
        set unassigned_optionlist($area_id) "<em>None available</em>"
    }

    append table_rows "
    <tr bgcolor=#e0e0e0>
        <td colspan=2><b>$name_of_area($area_id)</b>
            &nbsp;&nbsp; 
            <span class=tiny>
                (<a href=area-ae?area_id=$area_id>edit</a>)
                (<a href=area-delete?area_id=$area_id>delete area</a>)
            </span>
        </td>
    </tr>
    <tr bgcolor=#efefef valign=top>
        <td width=\"50%\">
        Default Assignees: $assigned_list($area_id)
        </td>
        <form action=default-assignee-ae>
        <input type=hidden name=area_id value=$area_id>
        <td width=\"50%\">
        Add default assignee:
        $unassigned_optionlist($area_id)
        </td>
        </form>
    </tr>"
}
