<?xml version="1.0"?>

<queryset>
   <rdbms><type>postgresql</type><version>7.1</version></rdbms>

<fullquery name="get_users">
<querytext>

select v.area_id,
       v.name,
       v.full_name,
       v.user_id,
       case when a.user_id is null then 0 else 1 end as already_assigned_p
  from (select ta.area_id, 
               ta.name,
               p.first_names || ' ' || p.last_name as full_name,
               tu.user_id
         from ttl_va_areas ta, ttl_v_users tu, persons p
         where ta.context_id = :package_id and 
               tu.package_id = :package_id and 
               tu.user_id = p.person_id) v
       left join ttl_area_assignments a using (area_id, user_id)
  order by v.name, v.full_name

</querytext>
</fullquery>

 
</queryset>
