ad_page_contract {
    
    Purpose: Delete a feature area
    
    If there are no tickets attached to this area, we really
    delete it from the database. Otherwise we do a soft
    delete.

} {
    area_id:integer,notnull
    {action delete}
    {return_url index}
}


if [string equal $action restore] {

    db_dml activate_area {
        update ttl_areas set active_p = 't' where area_id = :area_id
    }
} else {
    db_dml inactivate_area {
        update ttl_areas set
            active_p = 'f'
        where area_id = :area_id
        and exists (select 1 
                    from ttl_v_tickets
                    where area_id = :area_id)
    }
    
    if {[db_resultrows] == 0} {
        # Then there are no tickets attached to this area,
        # so we'll really delete it.
    
        db_transaction {
            db_dml delete_assignment {
                delete from ttl_area_assignments where area_id = :area_id
            }
            db_dml delete_area {
                delete from ttl_areas where area_id = :area_id
            }
        }
    }
}

ad_returnredirect $return_url
