ad_page_contract {} {
    name:trim,notnull
    area_id:integer,optional
    {return_url:optional index}
}

ttl_restrict_to_ttl_users

set caller_id  [ad_conn user_id]
set package_id [ad_conn package_id]
set caller_ip  [ns_conn peeraddr]

if ![info exists area_id] {

    db_transaction {
    
        set area_id [db_exec_plsql new_area {
          begin
           :1 := acs_object.new(
                object_type   => 'ticket_tracker_lite_area',
                creation_user => :caller_id,
                creation_ip   => :caller_ip,
                context_id    => :package_id
            );
          end;
        }]
    
        db_dml insert_area {
            insert into ttl_areas (area_id, name)
            values (:area_id, :name)
        }
    }

} else {
    db_dml update_area {
        update ttl_areas set name = :name where area_id = :area_id
    }
}

ad_returnredirect $return_url
