(function() {
	var Event=YAHOO.util.Event,
        Dom=YAHOO.util.Dom,
        oACDS, oAutoComp,
        show = {
            'missing': true,
            'mismatch': true,
            'extra': true,
            'protected': false,
            'deprecated': false
        };

Event.onAvailable('yui-classopts-form', function() {
/*Event.onDOMReady(function() {*/
    //Checkboxes are available..
    var handleClick = function(e,onReady) {
        var id, checked = false;
        if (YAHOO.lang.isString(e)) {
            id = e;
        } else {
            var tar = Event.getTarget(e);
            id = tar.id;
        }
        var el = Dom.get(id);
        checked = el.checked;

        var className = id;
        if (checked) {
            show[id.replace('show_', '')] = true;
            Dom.addClass(document.body, className);
            YAHOO.util.Cookie.setSub('yuidoc', id, 'checked');
        } else {
            show[id.replace('show_', '')] = false;
            Dom.removeClass(document.body, className);
            YAHOO.util.Cookie.setSub('yuidoc', id, '');
        }
    };

    var checkCookie = function(id) {
        var value = YAHOO.util.Cookie.getSub('yuidoc', id),
        el = Dom.get(id), checked = false;
	if (value === null) {
	    /* there is no (sub-)cookie set, apply defaults */
	    checked = el.defaultChecked;
	} else {
	    checked = (value === 'checked');
	}
        el.checked = checked;
        return checked;
    };

    var els = [
    'show_protected',
    'show_missing',
    'show_mismatch',
    'show_extra',
    'show_deprecated'],
        reapplyHash = false;

    for (var i = 0; i < els.length; i++) {
        Event.on(els[i], 'click', handleClick);
        reapplyHash = checkCookie(els[i]) || reapplyHash;
        handleClick(els[i]);
    }

    // If we dynamically show private/protected/etc items during
    // load, we need to reapply anchors so that the search feature
    // works correctly for items that are initially hidden.
    if (reapplyHash) {
        var dl = document.location, hash = dl.hash;
        if (hash) {
            dl.hash = hash;
        }
    }
    
});

//Starting the AutoComplete code
    var getResults = function(query) {
        var results = [];
        if(query && query.length > 0) {

            var q = query.toLowerCase();

            for (var i=0, len=ALL_YUI_PROPS.length; i<len; ++i) {

                var prop = ALL_YUI_PROPS[i];

                if (!show['protected'] && prop.access == "protected") {
                    // skip
                } else if (!show['private'] && prop.access == "private") {
                    // skip
                } else if (!show['deprecated'] && prop.deprecated) {
                    // skip
                } else {
                    var s = (prop.host + "." + prop.name).toLowerCase();
                    if (s.indexOf(q) > -1 ) {
                        results.push([query, prop]);
                    }
                }
            }
        }

        return results;
    };

    // Define Custom Event handlers
    var myOnDataReturn = function(sType, aArgs) {
        var oAutoComp = aArgs[0];
        var query = aArgs[1];
        var aResults = aArgs[2];

        if(aResults.length == 0) {
            if (query.length > 0) {
                oAutoComp.setBody("<div id=\"resultsdefault\">Not found</div>");
            }
        }
    };

    var myOnItemSelect = function(sType, aArgs) {
        var ac = aArgs[0];
        var item = aArgs[2];
        location.href = item[1].url;
    };


    Event.onAvailable("searchresults", function() {

        // Instantiate JS Function DataSource
        oACDS = new YAHOO.widget.DS_JSFunction(getResults);
        oACDS.maxCacheEntries = 30;

        // Instantiate AutoComplete
        oAutoComp = new YAHOO.widget.AutoComplete('searchinput','searchresults', oACDS);
        //oAutoComp.alwaysShowContainer = true;
        oAutoComp.queryDelay = 0.2;
        oAutoComp.maxResultsDisplayed = 200;
        oAutoComp.minQueryLength = 0;
        oAutoComp.formatResult = function(oResultItem, query) {
            var sMarkup = "<em>" + oResultItem[1].host + '</em> <span>' + oResultItem[1].name + '</span> <em>(' + oResultItem[1].type.toLowerCase() +')</em>';
            return sMarkup;
        };

        // Subscribe to Custom Events
        oAutoComp.dataReturnEvent.subscribe(myOnDataReturn);
        oAutoComp.itemSelectEvent.subscribe(myOnItemSelect);
        
        // Set initial content in the container
        oAutoComp.sendQuery(Dom.get("searchinput").value);

    });

    var validateForm = function() {
        return false;
    };
    
    YAHOO.util.Event.onAvailable('classTab', function() {
        var tabs = new YAHOO.widget.TabView('classTab');
    });
    /*
    YAHOO.util.Event.onAvailable('codeTree', function() {
        var tree1 = new YAHOO.widget.TreeView('codeTree');
        tree1.render();    
    });
    */

})();
